;HELP FOR PLOTS
  
 (defmeth terms-in-model-name-list :plot-help ()
      (plot-help-window (strcat "Help for " (send self :title)))
      (paste-plot-help (format nil "This window lists the terms for the loglinear model currently shown. his windows also allows for selecting new models. Clicking or dragging selects/removes individual terms. Extending selections can be carried out using Ctrl plus clicking or dragging.It has two modes of working:
HIERARCHICAL: This is the default method of working. Selecting an item in the list selects all the  items in the list associated with it. For example, selecting an item that corresponds to the interaction of two variables will also select automatically the two individual variables. Selecting a three variables interaction will select all the two variables interactions and the individual variables. 
NON-HIERARCHICAL: Each term in the list is selected individually. You can select models that are non-hierarchical. An item in the menu for the list allows for changing the mode of working.
~2%"))
      (show-plot-help))
(defmeth cook-plot :plot-help ()
      (plot-help-window (strcat "Help for " (send self :title)))
      (paste-plot-help (format nil "This plot represents two different but related quantities. 
LEVERAGES: Leverages measure how extreme it is a data point on the terms in the model, not in the response. Leverages are between 0 and 1. A high leverage indicates that the point is extreme in the space of predictors and is a potential outlier. Leverages are useful to detect influential points.
COOK'S DISTANCE: This distance measures the influence of a data point on the estimated coefficients of the model. It computes the impact of deleting a case and is a combination of leverages -distances between data points for the predictors- and residuals -distances between response and predicted-.~2%"))
      (show-plot-help))
(when use-mosaic-plot?
      (defmeth mp :plot-help ()
        (plot-help-window (strcat "Help for " (send self :title)))
        (paste-plot-help (format nil "This mosaic plot shows observed values v. adjusted chi square residuals for the model. The size of the rectangles in the plots is proportional to the frequency of the corresponding combination of categories. The color of the cells depends on the fitted model and the predicted values for the frequencies. Red means negative residuals. Blue, positive residuals. The hue of the color changes according to the value of the residual. A model with good fit will show white rectangles.~2%"))
        (show-plot-help)))

(defmeth count-residual :plot-help ()
      (plot-help-window (strcat "Help for " (send self :title)))
      (paste-plot-help (format nil "This plot shows the observed values for the combination of categories and the residuals for the cell. ~2%"))
      (show-plot-help))

(defmeth obs-list :plot-help ()
      (plot-help-window (strcat "Help for " (send self :title)))
      (paste-plot-help (format nil "This plot shows the labels for the observations in the data analyzed.~2%"))
      (show-plot-help))

(defmeth resplot :plot-help ()
      (plot-help-window (strcat "Help for " (send self :title)))
      (paste-plot-help (format nil "This plot shows the adjusted chi square residuals for the combination of categories v. the predicted value for it.~2%"))
      (show-plot-help))

(defmeth dev-plot :plot-help ()
      (plot-help-window (strcat "Help for " (send self :title)))
      (paste-plot-help (format nil "This plot shows the deviance of the model divided by the residual degrees of freedom. A model with a good fit will have a value lower than 1 in this quantity and will fall below the green line. Clicking on a point in this plot will return the spreadplot to the quantities associated with the corresponding model. Selecting two points will produce a comparison between the two models if the models are nested.~2%"))
      (show-plot-help))